<%@ page language="java" import="java.util.*" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%
	String path = request.getContextPath();
	String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort()
			+ path + "/";
%>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<base href="<%=basePath%>"/>
<link rel="stylesheet" type="text/css" href="<%= request.getContextPath()%>/resources/mta/css/course.css" />
<script src="<%=request.getContextPath()%>/resources/js/jquery-easyui-1.4/jquery.min.js" type="text/javascript"></script>
</head>
<body>
	<div id="header">
		<c:import url="header.jsp"></c:import>
	</div>
	<div id="main" class="w">
		<div class="title">
			<div class="nav_crumbs l">
				<!-- 全部课程 -->
				<span><spring:message code="label.font.allcourse"/></span>
				<span id="h2text" style="max-width:500px;"></span>
			</div>
			<div class="search r">
				<input type="text" name="" id="searchText" value="" placeholder="<spring:message code="label.font.search"/>" class="l" />
				<a onclick="searchData()"><span class="r"></span></a>
			</div>
		</div>
		<!-- 课程分类开始 -->
		<div class="menu w">
			<div class="type w" id="kcClassifyUl">
			<!-- 课程类型： -->
				<span class="l"><spring:message code="label.font.coursetype"/></span>
				<ul class="detail l" id="">
				</ul>
			</div>
			<div class="status w" id="kcStatusUl">
				<!-- 课程状态 -->
				<span class="l"><spring:message code="label.font.coursestatus"/></span>
				<ul class="detail l">
					<!-- 全部 -->
					<li class="l active" id="selectedKczt_0"><spring:message code="combobox.all"/></li>
					<!-- 公共课 -->
					<li class="l" id="selectedKczt_1"><spring:message code="label.font.kczt1"/></li>
					<!-- 即将开始 -->
					<li class="l" id="selectedKczt_3"><spring:message code="label.font.kczt3"/></li>
					<!-- 正在开课 -->
					<li class="l" id="selectedKczt_2"><spring:message code="label.font.kczt2"/></li>
					<!-- 已结束 -->
					<li class="l" id="selectedKczt_4"><spring:message code="label.font.kczt4"/></li>
				</ul>
			</div>
		</div>
		<!-- 课程分类结束 -->
		<!-- 课程列表开始 -->
		<div class="content">
			<div class="course_title">
				<!-- 最新 -->
				<span class="active" onclick="changeStatus('zx',this)" ><spring:message code="label.font.zx"/></span>
				<!-- 最热 -->
				<span onclick="changeStatus('zr',this)"><spring:message code="label.font.zr"/></span>
			</div>
			<div id="courseListDiv"></div>
		</div>
		<!-- 课程列表结束 -->
		<!-- 分页开始 -->
		<div class="numb" id="coursePage">
			<%@include file="page.jsp" %>
		</div>
		<!-- 分页结束 -->
	</div>
	<!--start footer-->
	<div id="footer">
		<c:import url="footer.jsp"></c:import>
	</div>
	<!--end footer-->
</body>

<script type="text/javascript">
	var language="<%=session.getAttribute("language")%>"; 
	if (language.indexOf('en') > -1) {
		document.write("<script src='" + baseUrl + "/resources/js/jquery-easyui-1.4/locale/easyui-lang-en.js'><\/script>");
		document.write("<script src='" + baseUrl + "/resources/js/mta_en/F010Course.js'><\/script>");
	} else {
		// 默认中文
		document.write("<script src='" + baseUrl + "/resources/js/jquery-easyui-1.4/locale/easyui-lang-zh_CN.js'><\/script>");
		document.write("<script src='" + baseUrl + "/resources/js/mta/F010Course.js'><\/script>");
	}
</script>
</html>
